<?php
require_once "../Api.php";
require "./get/getUsers.php";
require "./put/updateUsers.php";
require "./post/createUsers.php";
require "./patch/changeUsers.php";
require "./delete/deleteUsers.php";

class usersApi extends Api
{
   public $apiName = "users";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/Users
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "users":
               return isset($id) ? getUser($id) : getAllUsers();
               break;
            case "usersMulti":
               return getAllUsersMulti();
               break;
            case "access":
               return getAccess();
               break;
            case "exist":
               return getExist();
               break;
            case "connected":
               return getConnected();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/Users
    * @return string
    */
   public function createAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "users":
               if (isset($id)) {
                  addUser($id);
               }
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/Users
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "users":
               editUser($id);
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/Users
    * @return string
    */
   public function updateAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    newConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/Users
    * @return string
    */
   public function deleteAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "users":
               deleteUser($id);
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }
}
